/* xxxtgamma.h -- common _[FL]Tgamma functionality */
#include "xmath.h"
_STD_BEGIN

	/* coefficients */

 #if   FBITS <= 28
  #define DPOLY(x)	(((c[0] * x + c[1]) * x + c[2]) * x + c[3])
  #define NPOLY(x)	((((s[0] * x + s[1]) * x + s[2]) * x + s[3]) * x + s[4])

static const FTYPE s[] = {	/* 4/3, gamma(x + 2) 0 <= x <= 1 */
	FLIT( 0.0150817768),
	FLIT( 0.0461430996),
	FLIT( 0.2482699493),
	FLIT( 0.4603138768),
	FLIT( 1.0535332111),
	};

static const FTYPE c[] = {
	FLIT( 0.0351502919),
	FLIT(-0.1919087499),
	FLIT( 0.0148962022),
	FLIT( 1.0535332140),
	};

 #elif FBITS <= 56
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 7/6, gamma(x + 2) 0 <= x <= 1 */
	FLIT( 0.00001911260496487661),
	FLIT( 0.00030695850951705539),
	FLIT( 0.00236066588013570581),
	FLIT( 0.01566608576864586629),
	FLIT( 0.06864538166544283621),
	FLIT( 0.25564204431678150071),
	FLIT( 0.58132014526873860157),
	FLIT( 0.99526155629301685894),
	};

static const FTYPE c[] = {
	FLIT( 0.00022583646561960545),
	FLIT(-0.00324709000967967274),
	FLIT( 0.01370429194489334274),
	FLIT( 0.01524747217043957398),
	FLIT(-0.22212024165299313923),
	FLIT( 0.16053914994232507544),
	FLIT( 0.99526155629301687098),
	};

 #elif FBITS <= 65
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 8/7, gamma(x + 2) 0 <= x <= 1 */
	FLIT( 0.0000069716898002396278093),
	FLIT( 0.0000618397767220784540591),
	FLIT( 0.0006263695214940795307117),
	FLIT( 0.0037596879882907282162809),
	FLIT( 0.0211037302034084884023684),
	FLIT( 0.0830656463740010655630869),
	FLIT( 0.2827134204818275672838601),
	FLIT( 0.6050760028287359320850848),
	FLIT( 0.9727670083292563620050324),
	};

static const FTYPE c[] = {
	FLIT(-0.0000023556934303440378989),
	FLIT( 0.0001775337209603174422488),
	FLIT(-0.0025215358075821813479868),
	FLIT( 0.0118269361696126876711409),
	FLIT( 0.0083865335688919982680234),
	FLIT(-0.1998491316974667969485137),
	FLIT( 0.1938053500065262275246603),
	FLIT( 0.9727670083292563620200964),
	};

 #elif FBITS <= 116
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 12/12, gamma(x + 2) 0 <= x <= 1 */
	FLIT( 0.00000000017525541257720152745280511),
	FLIT( 0.00000000482674875973526061191451715),
	FLIT( 0.00000009012041828776291946031594088),
	FLIT( 0.00000121422207780042866174841042960),
	FLIT( 0.00001318649838615389091239788260837),
	FLIT( 0.00011665174871831064818048612136578),
	FLIT( 0.00086173243425000409145272583760631),
	FLIT( 0.00526985401712467337758461990587898),
	FLIT( 0.02660383198086210423491213609867877),
	FLIT( 0.10736968963690881285595543908901725),
	FLIT( 0.33459196448893963888328260827705123),
	FLIT( 0.72263070451556034110669102294327783),
	FLIT( 0.90175354914918324706206702603662461),
	};

static const FTYPE c[] = {
	FLIT( 0.00000000061069424974470207458888546),
	FLIT(-0.00000002438445726916832445523212394),
	FLIT( 0.00000039458416301687156914813946588),
	FLIT(-0.00000282796714222220284528622279754),
	FLIT( 0.00000017350029270898212683424325697),
	FLIT( 0.00014011630272881297757994915690286),
	FLIT(-0.00078112008463061273421333342401170),
	FLIT(-0.00072152957313866891395251893098327),
	FLIT( 0.01916632017818267761612546628226722),
	FLIT(-0.03021416368030030959012965748492377),
	FLIT(-0.18111808154419885109893357578420646),
	FLIT( 0.34138342981583999378176923377454466),
	FLIT( 0.90175354914918324706206702603662462),
	};

 #else /* FBITS */
  #error _Tgamma has insufficient precision
 #endif /* FBITS */

FTYPE FNAME(Tgamma)(FTYPE x)
	{	/* compute gamma(x), |x| <= Gamma_big */
	FTYPE y;

	if (x < FLIT(2.0))
		{	/* increase x to [2, 3] by recurrence relation */
		for (y = FLIT(1.0); x < FLIT(2.0); x += FLIT(1.0))
			y *= x;
		x -= FLIT(2.0);
		return ((NPOLY(x) / DPOLY(x)) / y);
		}
	else
		{	/* decrease x to [2, 3] by recurrence relation */
		for (y = FLIT(1.0); FLIT(3.0) < x; y *= x)
			x -= FLIT(1.0);
		x -= FLIT(2.0);
		return ((NPOLY(x) / DPOLY(x)) * y);
		}
	}
_STD_END

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
